<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.examinations-show')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.examinations')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <style>
        /* Modern minimal design styling */
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #4cc9f0;
            --success-color: #2ec4b6;
            --info-color: #3a86ff;
            --warning-color: #ff9f1c;
            --danger-color: #e63946;
            --dark-color: #212529;
            --light-color: #f8f9fa;
            --border-color: #e9ecef;
            --shadow-sm: 0 2px 4px rgba(0,0,0,0.03);
            --shadow-md: 0 4px 6px rgba(0,0,0,0.04);
            --shadow-lg: 0 10px 15px rgba(0,0,0,0.05);
            --transition: all 0.2s ease;
            --border-radius: 8px;
        }

        /* Card styling */
        .card-docs {
            border: none;
            box-shadow: var(--shadow-lg);
            border-radius: var(--border-radius);
            overflow: hidden;
            margin-bottom: 2rem;
            transition: var(--transition);
            background-color: white;
        }

        .card-header {
            background-color: white !important;
            border-bottom: 1px solid var(--border-color) !important;
            padding: 1.25rem 1.5rem !important;
        }

        .card-body {
            padding: 1.5rem !important;
        }

        /* Section styling */
        .section-heading {
            color: var(--dark-color);
            font-weight: 600;
            margin-bottom: 1.25rem;
            padding-bottom: 0.75rem;
            border-bottom: 1px solid var(--border-color);
            position: relative;
            display: flex;
            align-items: center;
            font-size: 1.25rem;
        }

        .section-heading i {
            margin-right: 0.5rem;
            color: var(--primary-color);
            font-size: 1.2rem;
        }

        .section-heading:after {
            content: '';
            position: absolute;
            bottom: -1px;
            left: 0;
            width: 40px;
            height: 2px;
            background: var(--primary-color);
            border-radius: 2px;
        }

        /* Details items styling */
        .details-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .details-item {
            display: flex;
            flex-direction: column;
            padding: 1rem;
            border-radius: var(--border-radius);
            background-color: #fafafa;
            box-shadow: var(--shadow-sm);
            transition: var(--transition);
            border-left: 3px solid var(--primary-color);
            height: 100%;
        }

        .details-item:hover {
            box-shadow: var(--shadow-md);
            transform: translateY(-2px);
        }

        .details-title {
            font-weight: 500;
            color: #6c757d;
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            font-size: 0.875rem;
        }

        .details-title i {
            margin-right: 0.4rem;
            color: var(--primary-color);
            font-size: 1rem;
        }

        .details-value {
            font-weight: 500;
            color: var(--dark-color);
            font-size: 1rem;
            background-color: white;
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
            box-shadow: var(--shadow-sm);
            word-break: break-word;
        }

        /* Status items */
        .status-item {
            border-left-color: var(--info-color);
        }

        .status-item .details-title i {
            color: var(--info-color);
        }

        /* Notes styling */
        .notes-container {
            background-color: #f8f9fa;
            border-radius: var(--border-radius);
            padding: 1.25rem;
            margin-bottom: 2rem;
            border-left: 3px solid var(--warning-color);
            box-shadow: var(--shadow-sm);
        }

        .notes-container .details-title i {
            color: var(--warning-color);
        }

        .notes-container .details-value {
            background-color: white;
        }

        /* Table styling */
        .table-container {
            border-radius: var(--border-radius);
            box-shadow: var(--shadow-md);
            overflow: hidden;
            margin-bottom: 2rem;
        }

        .table {
            margin-bottom: 0;
        }

        .table th {
            background-color: var(--primary-color);
            color: white;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-size: 0.8rem;
            padding: 0.75rem 1rem;
            border: none;
            font-weight: 500;
        }

        .table td {
            font-size: 0.95rem;
            padding: 0.75rem 1rem;
            border-color: var(--border-color);
            vertical-align: middle;
            color: var(--dark-color);
            font-weight: 400;
        }

        .table tbody tr {
            transition: var(--transition);
        }

        .table tbody tr:hover {
            background-color: rgba(67, 97, 238, 0.03);
        }

        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, 0.02);
        }

        /* Button styling */
        .btn {
            padding: 0.5rem 1.25rem;
            font-weight: 500;
            border-radius: 6px;
            transition: var(--transition);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.4rem;
            font-size: 0.9rem;
            box-shadow: var(--shadow-sm);
        }

        .btn i {
            font-size: 1rem;
        }

        .btn-primary {
            background-color: var(--primary-color);
            border: none;
            color: white;
        }

        .btn-primary:hover {
            background-color: var(--secondary-color);
            box-shadow: 0 4px 10px rgba(67, 97, 238, 0.2);
            transform: translateY(-1px);
        }

        .btn-secondary {
            background-color: #f1f3f5;
            border: none;
            color: var(--dark-color);
        }

        .btn-secondary:hover {
            background-color: #e9ecef;
            box-shadow: var(--shadow-md);
            transform: translateY(-1px);
        }

        .btn-success {
            background-color: var(--success-color);
            border: none;
            color: white;
        }

        .btn-success:hover {
            background-color: #219d92;
            box-shadow: 0 4px 10px rgba(46, 196, 182, 0.2);
            transform: translateY(-1px);
        }

        /* Badge styling */
        .badge {
            padding: 0.4rem 0.7rem;
            border-radius: 50px;
            font-weight: 500;
            font-size: 0.8rem;
        }

        .badge-primary {
            background-color: rgba(67, 97, 238, 0.1);
            color: var(--primary-color);
        }

        /* Print styling */
        @media print {
            header, .navbar, .card-header, .footer, .btn, .d-flex {
                display: none;
            }

            .card-docs {
                box-shadow: none;
                border: none;
            }

            .card-body {
                padding: 0 !important;
            }

            .details-item, .notes-container {
                box-shadow: none;
                border: 1px solid #eee;
            }

            .details-value {
                box-shadow: none;
            }

            .table th {
                background-color: #eee !important;
                color: #333 !important;
            }

            .table, .table th, .table td {
                border: 1px solid #ddd;
            }

            i.fas, i.far, i.fa {
                display: none;
            }
        }
    </style>

    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card card-docs mb-2">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div class="card-title m-0">
                                    <h3 class="fw-bolder m-0">
                                        <i class="fas fa-file-medical  me-2"></i>
                                        <?php echo e(__('translations.examination_details')); ?>

                                    </h3>
                                </div>
                            </div>
                            <div class="card-body">
                                <!-- Client Information Section -->
                                <h4 class="section-heading">
                                    <i class="fas fa-user-alt p-2 " style="font-size: 1.5rem;"></i>
                                    <?php echo e(__('translations.Client Information')); ?>

                                </h4>

                                <div class="details-container ">
                                    <div class="details-item">
                                        <span class="details-title">
                                            <i class="fas fa-hashtag p-2" style="font-size: 1.5rem;"></i>
                                            <?php echo e(__('translations.Examination Code')); ?>

                                        </span>
                                        <span class="details-value"><?php echo e($examination->code); ?></span>
                                    </div>

                                    <div class="details-item">
                                        <span class="details-title">
                                            <i class="fas fa-user p-2 " style="font-size: 1.5rem;"></i>
                                            <?php echo e(__('translations.Client name')); ?>

                                        </span>
                                        <span class="details-value">
                                            <div class="d-flex align-items-center">
                                                <?php echo e($examination->client->first_name); ?> <?php echo e($examination->client->last_name); ?>

                                            </div>
                                        </span>
                                    </div>

                                    <div class="details-item">
                                        <span class="details-title">
                                            <i class="fas fa-phone-alt p-2" style="font-size: 1.5rem;"></i>
                                            <?php echo e(__('translations.phone')); ?>

                                        </span>
                                        <span class="details-value">
                                            <?php echo e($examination->client->phone); ?>

                                        </span>
                                    </div>

                                    <div class="details-item">
                                        <span class="details-title">
                                            <i class="fas fa-tag p-2 " style="font-size: 1.5rem;"></i>
                                            <?php echo e(__('translations.type')); ?>

                                        </span>
                                        <span class="details-value">
                                            <span class="badge badge-primary">
                                                <?php echo e($examination->type); ?>

                                            </span>
                                        </span>
                                    </div>
                                </div>


                                <!-- Notes Section -->
                                <div class="notes-container">
                                    <span class="details-title">
                                        <i class="fas fa-sticky-note p-2 " style="font-size: 1.5rem;"></i>
                                        <?php echo e(__('translations.Note')); ?>

                                    </span>
                                    <span class="details-value d-block p-3">
                                        <?php echo e(empty($examination->notes) ? 'لا توجد ملاحظات' : $examination->notes); ?>

                                    </span>
                                </div>

                                <!-- Attachment Section -->
                                <?php if(!empty($examination->file)): ?>
                                    <div class="d-flex justify-content-start mb-4">
                                        <a href="<?php echo e(asset('uploads/' . $examination->file)); ?>" class="btn btn-success"
                                            download>
                                            <i class="fas fa-download"></i>
                                            تحميل المرفق
                                        </a>
                                    </div>
                                <?php endif; ?>

                                <!-- Examination Results Section -->
                                <h4 class="section-heading">
                                    <i class="fas fa-clipboard-list p-2 " style="font-size: 1.5rem;"></i>
                                    <?php echo e(__('translations.Examination Results')); ?>

                                </h4>

                                <!-- جدول بيانات الفحص -->
                                <div class="table-container" dir="ltr">
                                    <div class="table-responsive">
                                        <table class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('translations.Type')); ?></th>
                                                    <th><?php echo e(__('translations.Sph')); ?></th>
                                                    <th><?php echo e(__('translations.Cyl')); ?></th>
                                                    <th><?php echo e(__('translations.Axis')); ?></th>
                                                    <th><?php echo e(__('translations.I.P.D')); ?></th>
                                                    <th><?php echo e(__('translations.A.D.D')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody id="details-table-body">
                                                <?php $__currentLoopData = $examination->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($item->type); ?></td>
                                                        <td><?php echo e($item->sph); ?></td>
                                                        <td><?php echo e($item->cyl); ?></td>
                                                        <td><?php echo e($item->axis); ?></td>
                                                        <td><?php echo e($item->add); ?></td>
                                                        <td><?php echo e($item->lpd); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <!-- أزرار الرجوع والطباعة -->
                                <div class="d-flex pt-3 justify-content-between align-items-center">
                                    <a href="<?php echo e(route('admin.receptions.index')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left"></i>
                                        <?php echo e(__('translations.back')); ?>

                                    </a>
                                    <a href="<?php echo e(route($examination->special ? 'admin.receptions.print_special' : 'admin.receptions.print', $examination->id)); ?>"
                                        class="btn btn-primary" target="_blank">
                                        <i class="fas fa-print"></i>
                                        <?php echo e(__('translations.print')); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/opticsin/public_html/4eye.innovationstars.net/resources/views/admin/receptions/show.blade.php ENDPATH**/ ?>