<?php $__env->startSection('title'); ?>
    <?php echo e(__('translations.settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('sub-title'); ?>
    <?php echo e(__('translations.settings management')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
        <div class="post d-flex flex-column-fluid" id="kt_post">
            <div id="kt_content_container" class="container-fluid">
                <div class="row g-3">
                    <div class="col-12">
                        <div class="card shadow-sm border-0 mb-4">
                            <div class="card-header border-0 d-flex flex-column flex-md-row align-items-md-center justify-content-between" style="background: linear-gradient(to right, #3a7bd5, #00d2ff);">
                                <div class="mb-2 mb-md-0">
                                    <h3 class="fw-bold m-0 text-white"><?php echo e(__('translations.settings management')); ?></h3>
                                </div>
                                <div class="d-flex">
                                    <div class="form-check form-switch form-check-custom form-check-solid me-3">
                                        <input class="form-check-input" type="checkbox" id="viewToggle" checked />
                                        <label class="form-check-label text-white" for="viewToggle">
                                            <?php echo e(__('translations.compact view')); ?>

                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <!-- Settings Navigation Tabs -->
                                <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x nav-stretch fs-5 fw-bold border-0" id="settings-tabs" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link active px-3 px-lg-5" id="general-tab" data-bs-toggle="tab" href="#general" role="tab" aria-controls="general" aria-selected="true">
                                            <i class="fas fa-cogs me-2"></i><?php echo e(__('translations.general')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link px-3 px-lg-5" id="communication-tab" data-bs-toggle="tab" href="#communication" role="tab" aria-controls="communication" aria-selected="false">
                                            <i class="fas fa-comment-dots me-2"></i><?php echo e(__('translations.communication')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link px-3 px-lg-5" id="system-tab" data-bs-toggle="tab" href="#system" role="tab" aria-controls="system" aria-selected="false">
                                            <i class="fas fa-server me-2"></i><?php echo e(__('translations.system')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link px-3 px-lg-5" id="additional-tab" data-bs-toggle="tab" href="#additional" role="tab" aria-controls="additional" aria-selected="false">
                                            <i class="fas fa-plus-circle me-2"></i><?php echo e(__('translations.additional settings')); ?>

                                        </a>
                                    </li>
                                </ul>

                                <!-- Settings Tab Content -->
                                <div class="tab-content" id="settings-content">
                                    <!-- General Settings Tab -->
                                    <div class="tab-pane fade show active p-4" id="general" role="tabpanel" aria-labelledby="general-tab">
                                        <div class="row g-4 settings-grid">
                                            <!-- General Setting -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.general')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-primary d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-cogs fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.general settings')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage basic app configurations')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-primary"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <!-- Theme Setting -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.theme.presets')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-info d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-paint-brush fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.theme settings')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.customize colors and appearance')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-info"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Communication Settings Tab -->
                                    <div class="tab-pane fade p-4" id="communication" role="tabpanel" aria-labelledby="communication-tab">
                                        <div class="row g-4 settings-grid">
                                            <!-- WhatsApp Setting -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.whatsapp')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-success d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-phone fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.whatsapp settings')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.configure whatsapp integration')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-success"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <!-- WhatsApp Template -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.whatsapp.template.home')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-info d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-comments fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.whatsapp template')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage message templates')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-info"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <!-- Invotek Setting -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.invotek')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-warning d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-credit-card fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.invotek settings')); ?></h5>
                                                                <?php
                                                                    $invotek = \App\Models\Invotek::first();
                                                                ?>
                                                                <?php if($invotek->active == 1): ?>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                                <?php else: ?>
                                                                <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage payment integrations')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-warning"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <!-- Email Setting (Inactive) -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item inactive">
                                                <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                    <div class="setting-icon bg-secondary d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-envelope fa-2x text-white"></i>
                                                    </div>
                                                    <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <h5 class="setting-title mb-0"><?php echo e(__('translations.email settings')); ?></h5>
                                                            <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                        </div>
                                                        <p class="setting-description text-muted mb-3"><?php echo e(__('translations.configure email services')); ?></p>
                                                        <div class="mt-auto text-end">
                                                            <span class="btn btn-sm btn-light-secondary disabled"><?php echo e(__('translations.coming soon')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Email Template (Inactive) -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item inactive">
                                                <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                    <div class="setting-icon bg-secondary d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-envelope-open-text fa-2x text-white"></i>
                                                    </div>
                                                    <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <h5 class="setting-title mb-0"><?php echo e(__('translations.email template')); ?></h5>
                                                            <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                        </div>
                                                        <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage email templates')); ?></p>
                                                        <div class="mt-auto text-end">
                                                            <span class="btn btn-sm btn-light-secondary disabled"><?php echo e(__('translations.coming soon')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- System Settings Tab -->
                                    <div class="tab-pane fade p-4" id="system" role="tabpanel" aria-labelledby="system-tab">
                                        <div class="row g-4 settings-grid">
                                            <!-- Cron Job Settings -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.cron-job')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-secondary d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-clock fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.cron job settings')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.schedule automated tasks')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-secondary"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <!-- Backup Setting -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.backups')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-dark d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-database fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.backup_settings')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage_database_backups')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-dark"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>

                                            <!-- Cache Setting -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item">
                                                <a href="<?php echo e(route('admin.settings.cache')); ?>" class="text-decoration-none">
                                                    <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                        <div class="setting-icon bg-warning d-flex align-items-center justify-content-center">
                                                            <i class="fas fa-archive fa-2x text-white"></i>
                                                        </div>
                                                        <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                            <div class="d-flex justify-content-between mb-2">
                                                                <h5 class="setting-title mb-0"><?php echo e(__('translations.cache_settings')); ?></h5>
                                                                <span class="badge badge-success"><?php echo e(__('translations.active')); ?></span>
                                                            </div>
                                                            <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage_application_cache')); ?></p>
                                                            <div class="mt-auto text-end">
                                                                <span class="btn btn-sm btn-light-warning"><?php echo e(__('translations.manage')); ?> <i class="fas fa-arrow-right ms-1"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Additional Settings Tab -->
                                    <div class="tab-pane fade p-4" id="additional" role="tabpanel" aria-labelledby="additional-tab">
                                        <div class="row g-4 settings-grid">
                                            <!-- Currency Setting (Inactive) -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item inactive">
                                                <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                    <div class="setting-icon bg-success d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-coins fa-2x text-white"></i>
                                                    </div>
                                                    <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <h5 class="setting-title mb-0"><?php echo e(__('translations.currency settings')); ?></h5>
                                                            <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                        </div>
                                                        <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage currency options')); ?></p>
                                                        <div class="mt-auto text-end">
                                                            <span class="btn btn-sm btn-light-success disabled"><?php echo e(__('translations.coming soon')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Language Setting (Inactive) -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item inactive">
                                                <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                    <div class="setting-icon bg-primary d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-language fa-2x text-white"></i>
                                                    </div>
                                                    <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <h5 class="setting-title mb-0"><?php echo e(__('translations.language settings')); ?></h5>
                                                            <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                        </div>
                                                        <p class="setting-description text-muted mb-3"><?php echo e(__('translations.manage languages')); ?></p>
                                                        <div class="mt-auto text-end">
                                                            <span class="btn btn-sm btn-light-primary disabled"><?php echo e(__('translations.coming soon')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Notifications (Inactive) -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item inactive">
                                                <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                    <div class="setting-icon bg-warning d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-bell fa-2x text-white"></i>
                                                    </div>
                                                    <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <h5 class="setting-title mb-0"><?php echo e(__('translations.notifications settings')); ?></h5>
                                                            <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                        </div>
                                                        <p class="setting-description text-muted mb-3"><?php echo e(__('translations.configure notifications')); ?></p>
                                                        <div class="mt-auto text-end">
                                                            <span class="btn btn-sm btn-light-warning disabled"><?php echo e(__('translations.coming soon')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Security (Inactive) -->
                                            <div class="col-12 col-md-6 col-xl-4 setting-item inactive">
                                                <div class="setting-card d-flex h-100 rounded-3 overflow-hidden">
                                                    <div class="setting-icon bg-danger d-flex align-items-center justify-content-center">
                                                        <i class="fas fa-shield-alt fa-2x text-white"></i>
                                                    </div>
                                                    <div class="setting-content p-3 flex-grow-1 d-flex flex-column">
                                                        <div class="d-flex justify-content-between mb-2">
                                                            <h5 class="setting-title mb-0"><?php echo e(__('translations.security settings')); ?></h5>
                                                            <span class="badge badge-danger"><?php echo e(__('translations.inactive')); ?></span>
                                                        </div>
                                                        <p class="setting-description text-muted mb-3"><?php echo e(__('translations.configure security options')); ?></p>
                                                        <div class="mt-auto text-end">
                                                            <span class="btn btn-sm btn-light-danger disabled"><?php echo e(__('translations.coming soon')); ?></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Modern Tabs Styling */
        .nav-line-tabs {
            border-bottom: 1px solid #f5f8fa;
        }

        .nav-line-tabs .nav-item .nav-link {
            color: #5e6278;
            border: 0;
            border-bottom: 2px solid transparent;
            transition: color 0.3s ease, border-color 0.3s ease, background-color 0.3s ease;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            position: relative;
            overflow: hidden;
        }

        .nav-line-tabs .nav-item .nav-link:before {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 2px;
            background-color: #009ef7;
            transform: scaleX(0);
            transition: transform 0.3s ease;
            transform-origin: bottom right;
        }

        .nav-line-tabs .nav-item .nav-link:hover:before {
            transform: scaleX(1);
            transform-origin: bottom left;
        }

        .nav-line-tabs .nav-item .nav-link.active {
            color: #009ef7;
            border-bottom-color: #009ef7;
            background-color: rgba(0, 158, 247, 0.05);
        }

        .nav-line-tabs .nav-item .nav-link.active:before {
            transform: scaleX(1);
        }

        /* Setting Card Styling */
        .setting-card {
            background-color: #ffffff;
            box-shadow: 0 0.1rem 0.5rem rgba(0, 0, 0, 0.05);
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            border: 1px solid #e4e6ef;
            position: relative;
            z-index: 1;
        }

        .setting-card:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 100%);
            z-index: -1;
            transition: opacity 0.4s ease;
            opacity: 0;
        }

        .setting-card:hover {
            transform: translateY(-8px) scale(1.01);
            box-shadow: 0 0.5rem 1.5rem rgba(0, 0, 0, 0.1);
            border-color: rgba(0, 158, 247, 0.3);
        }

        .setting-card:hover:before {
            opacity: 1;
        }

        .setting-icon {
            min-width: 90px;
            position: relative;
            overflow: hidden;
            transition: all 0.4s ease;
        }

        .setting-icon:after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-100%);
            transition: transform 0.6s ease;
        }

        .setting-card:hover .setting-icon {
            transform: scale(1.05);
        }

        .setting-card:hover .setting-icon:after {
            transform: translateX(100%);
        }

        .setting-icon i {
            transition: transform 0.3s ease;
        }

        .setting-card:hover .setting-icon i {
            transform: rotate(10deg);
        }

        .setting-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: #181c32;
            transition: color 0.3s ease;
        }

        .setting-card:hover .setting-title {
            color: #009ef7;
        }

        .setting-description {
            font-size: 0.9rem;
            color: #7e8299;
            transition: color 0.3s ease;
        }

        /* Badge Styling */
        .badge {
            padding: 0.4rem 0.6rem;
            font-size: 0.75rem;
            font-weight: 500;
            transition: all 0.3s ease;
            border-radius: 50rem;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
        }

        .badge-success {
            background-color: #50cd89;
            color: #ffffff;
        }

        .badge-danger {
            background-color: #f1416c;
            color: #ffffff;
        }

        .setting-card:hover .badge {
            transform: scale(1.05);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        /* Inactive Setting Styling */
        .setting-item.inactive {
            opacity: 0.75;
            transition: opacity 0.3s ease;
        }

        .setting-item.inactive:hover {
            opacity: 0.9;
        }

        /* Responsive Settings */
        @media (max-width: 767px) {
            .settings-grid {
                display: flex;
                flex-direction: column;
            }

            .setting-item {
                margin-bottom: 1rem;
            }
        }

        /* Toggle Switch */
        .form-switch .form-check-input {
            width: 2.5rem;
            height: 1.25rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .form-switch .form-check-input:checked {
            background-color: #50cd89;
            border-color: #50cd89;
            box-shadow: 0 0 0 0.25rem rgba(80, 205, 137, 0.15);
        }

        .form-switch .form-check-label {
            cursor: pointer;
            user-select: none;
            transition: color 0.3s ease;
        }

        /* Button styling */
        .btn {
            transition: all 0.3s ease;
            border-radius: 0.475rem;
            font-weight: 500;
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 0.3rem 0.5rem rgba(0, 0, 0, 0.1);
        }

        /* Light button variations with improved styling */
        .btn-light-primary {
            background-color: rgba(0, 158, 247, 0.1);
            color: #009ef7;
            border: none;
        }

        .btn-light-primary:hover {
            background-color: #009ef7;
            color: #ffffff;
        }

        .btn-light-success {
            background-color: rgba(80, 205, 137, 0.1);
            color: #50cd89;
            border: none;
        }

        .btn-light-success:hover {
            background-color: #50cd89;
            color: #ffffff;
        }

        .btn-light-info {
            background-color: rgba(114, 57, 234, 0.1);
            color: #7239ea;
            border: none;
        }

        .btn-light-info:hover {
            background-color: #7239ea;
            color: #ffffff;
        }

        .btn-light-warning {
            background-color: rgba(255, 199, 0, 0.1);
            color: #ffc700;
            border: none;
        }

        .btn-light-warning:hover {
            background-color: #ffc700;
            color: #ffffff;
        }

        .btn-light-danger {
            background-color: rgba(241, 65, 108, 0.1);
            color: #f1416c;
            border: none;
        }

        .btn-light-danger:hover {
            background-color: #f1416c;
            color: #ffffff;
        }

        .btn-light-dark {
            background-color: rgba(24, 28, 50, 0.1);
            color: #181c32;
            border: none;
        }

        .btn-light-dark:hover {
            background-color: #181c32;
            color: #ffffff;
        }

        .btn-light-secondary {
            background-color: rgba(161, 165, 183, 0.1);
            color: #a1a5b7;
            border: none;
        }

        .btn-light-secondary:hover {
            background-color: #a1a5b7;
            color: #ffffff;
        }

        /* Tab content fade animation */
        .tab-pane {
            animation: fadeEffect 0.5s;
        }

        @keyframes fadeEffect {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Card hover animation */
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(0, 158, 247, 0.4); }
            70% { box-shadow: 0 0 0 10px rgba(0, 158, 247, 0); }
            100% { box-shadow: 0 0 0 0 rgba(0, 158, 247, 0); }
        }

        .setting-card:hover {
            animation: pulse 1.5s infinite;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const viewToggle = document.getElementById('viewToggle');
            const settingsGrid = document.querySelectorAll('.settings-grid');
            const settingItems = document.querySelectorAll('.setting-item');
            const tabs = document.querySelectorAll('.nav-link[data-bs-toggle="tab"]');

            // Apply animation class with delay to each setting card
            settingItems.forEach((item, index) => {
                setTimeout(() => {
                    item.style.opacity = "1";
                    item.style.transform = "translateY(0)";
                }, 100 * index);
            });

            // View toggle functionality
            viewToggle.addEventListener('change', function() {
                settingsGrid.forEach(grid => {
                    if (this.checked) {
                        // Compact view
                        grid.classList.remove('row-cols-1');
                        grid.classList.add('compact-view');
                    } else {
                        // List view
                        grid.classList.add('row-cols-1');
                        grid.classList.remove('compact-view');
                    }
                });
            });

            // Add animation when switching tabs
            tabs.forEach(tab => {
                tab.addEventListener('shown.bs.tab', function(e) {
                    const targetTab = document.querySelector(e.target.getAttribute('href'));
                    const items = targetTab.querySelectorAll('.setting-item');

                    items.forEach((item, index) => {
                        item.style.opacity = "0";
                        item.style.transform = "translateY(20px)";

                        setTimeout(() => {
                            item.style.opacity = "1";
                            item.style.transform = "translateY(0)";
                        }, 50 * index);
                    });
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tikpart/public_html/eyes.innovationstars.net/resources/views/admin/setting-management.blade.php ENDPATH**/ ?>